/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	int.c
*  :	Flynn Yin
*  :	V2.30
*  :	2018/10
*  :	ʾжϷ
*  ע:    HR7P201/202Ժݲɼ
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"
#include "stdlib.h"
//#include "tkm_config.h"
extern uint TK_value;

void Timerinit(void)
{                       
    T10C = 0x01;		//T10Ϊʱģʽ4Ƶ  8M/4= 2M  0.5us/Clock
    T10 = 6;			//趨ʱֵʱ8ms    250*32=8000us
    T10PRE = 1;			//ʹԤƵ  // 2 4 8 16 32 64 128 256
    T10IE = 1;			//ʹT10ʱж
    //GIE = 1;			//ʹȫж
    T10EN = 1;			//T10ENʱ
}

void it_vectors_init(void)
{
	INTVEN0 = 1;
	INTV0   = 0;
	INTV1   = 0;
	INTP    = 0x20;	//RX2 TX2 ȼ
	GIEL    = 1;
}

void isr_T10_handler(void) interrupt_low 0x0010
{
   uchar i;
 if (T10IE && T10IF)		//125us Timer
    {					    //붨ʱж
        T10IF = 0;		    //жϱ־
        T10 = T10 + 6;	    //سֵϽжʱ  T10 + 6;

		if(Opr_state &0x8000)  //At scan enable state
		{
			if(TKIF) // Check if scan complete TKGO TKIF TKGO==0
			{				         				 
		      union {
				     uchar dl[2];
				     uint  data;
			        }tkdata;

					if (TKDAH||TKOV||TKERR||SCANOV)                    //TKOV  TKERR SCANOV  Error
					 {
					  //tkdata.data = 0xFFFF;
					  //TK_value =0xFFFF;
					  //Wait the tk module reset
					  //FMQ_counter =1600;      //200ms FMQ any error for test 
				     } 
					else 
					{
					 tkdata.dl[0] = TKDAL;
					 tkdata.dl[1] = TKDAM;
					 TK_value =tkdata.data;
					 if(TK_value)
					 {
					  Timer_counter =0;              //Clear Measure time	for tk module
					  TK_value_get  =1;              //Set a flag for TK_value  update
					  Update_TKdata();               //Update channel data
					 }
					
				    }
					TKIF = 0;          // ж		
					TKIE = 0; 		   
			}
		}
		Timer_10ms++;
    }
}

void isr_i2c_tk_handler(void) interrupt_low 0x0020
{
	 uchar i;
 if(TKIE && TKIF)
    {     	 		
	  TKGO = 0;			 // Ӧģر
	  PA7  = 0;			 // Cxŵ
	  PAT7 = 0;          // Output0
	  TKIF = 0;          // ж			  
    }
}

void isr_uartx_handler(void) interrupt_high 0x001C
{
   uchar i;
   uchar temp;
   #if TK_UARToutput_function ==ON
   if(RX2IE && RX2IF)			//UARTж	
    {  
    	g_com = RX2B;		//UARTݼĴͬʱӲRXIF־  
		UploadBuf[0] = 0x68;
		UploadBuf[1] = 0x68;
		UploadBuf[2] = g_com;
		g_rp = 0;			 //ָ0
		Cnt_Mask = 0;
		g_checksum = 0;	 //У0
		if(g_tp ==0)         //Not in busy send state
		{
			if(g_com == COMMOND1)
			{				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2];	//Уͣۼֵ
				while( Cnt_Mask < (TK_NUM*2))
				{
					if(((ulong)0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{
						
						UploadBuf[g_rp+4] = UploadSampByte[Cnt_Mask];					
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
				}
				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TX2B = UploadBuf[0];	//дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND2)
			{
				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
				while(Cnt_Mask < (TK_NUM*2))
				{
					if(((ulong)0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{
						
						UploadBuf[g_rp+4] = UploadRawByte[Cnt_Mask];						
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
					
				}
				g_length =g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TX2B = UploadBuf[0];	//дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND3)
			{				
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] ;	//Уͣۼֵ
				while(Cnt_Mask < (TK_NUM*2))
				{
					if(((ulong)0x00000001 << (Cnt_Mask/2)) & ChannelMask)
					{
						
						UploadBuf[g_rp+4] = UploadBaseByte[Cnt_Mask];						
						g_checksum += UploadBuf[g_rp+4];	//Уͣۼֵ
						g_rp ++;
						Cnt_Mask++;
					}
					else
					{
						Cnt_Mask++;
					}
				}
				g_length = g_rp;
				UploadBuf[3] = g_rp;
				g_checksum += UploadBuf[3];
				UploadBuf[g_rp+4] = g_checksum;
				TX2B = UploadBuf[0];	//дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND4)  //ֵ
			{
				g_length = 9;
				UploadBuf[3] = 9;

				UploadBuf[4] = (uchar)(Opr_state);	     //Mode
				//#if  TK_Singlepress ==ON  
				//UploadBuf[5] = (uchar)(TK_state_single>>16);    //ֵH
				//UploadBuf[6] = (uchar)(TK_state_single>>8);	 //ֵM
				//UploadBuf[7] = (uchar)(TK_state_single);		 //ֵL
				//#else
				UploadBuf[5] = (uchar)(TK_state>>16);    //ֵH
				UploadBuf[6] = (uchar)(TK_state>>8);	 //ֵM
				UploadBuf[7] = (uchar)(TK_state);		 //ֵL
				//#endif

				#if  TK_Slider_Function ==ON  
				UploadBuf[8] = (uchar)(TK_slider_value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_slider_value);       //Byte L
				#else
				//UploadBuf[8] = 0;
				//UploadBuf[9] = 0;
				UploadBuf[8] = (uchar)(TK_jitter_Value>>8);    //Byte H
				UploadBuf[9] = (uchar)(TK_jitter_Value);       //Byte L
				#endif

				#if  TK_Wheel_Function ==ON  
				UploadBuf[10] = (uchar)(TK_wheel_value>>8);    //Byte H
				UploadBuf[11] = (uchar)(TK_wheel_value);       //Byte L
				#else
				UploadBuf[10] = 0;
				UploadBuf[11] = 0;
				#endif

				#if  TK_Matrix_Function ==ON  
				UploadBuf[12] =TK_Matrix_value ;               //Byte 			
				#else			
				UploadBuf[12] = 0;                             //Byte
				#endif
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3] + UploadBuf[4] + UploadBuf[5];	//Уͣۼֵ
				g_checksum += UploadBuf[6] + UploadBuf[7] + UploadBuf[8] + UploadBuf[9] + UploadBuf[10] + UploadBuf[11]+ UploadBuf[12];	//Уͣۼֵ
				UploadBuf[13] = g_checksum;
				TX2B = UploadBuf[0];	//дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}
			else if(g_com == COMMOND0)  //ͨ
			{
			    g_length     = 1;
				UploadBuf[3] = 1;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ				
				UploadBuf[4] =TK_NUM;
				g_checksum += UploadBuf[4];	                                                //Уͣۼֵ
				g_rp ++;								
				UploadBuf[g_rp+4] = g_checksum;
				TX2B = UploadBuf[0];	    //дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}
			else
			{
				temp = ((g_com & 0xF0) >> 4 ) -6;
				ChannelMask &= ~(0x0000000F << (temp*4));
				ChannelMask |= ((g_com & 0x0F) << (temp*4));
			    g_length     = 0;
				UploadBuf[3] = 0;
				g_checksum = UploadBuf[0] + UploadBuf[1] + UploadBuf[2] + UploadBuf[3];	    //Уͣۼֵ	
				g_rp ++;								
				UploadBuf[4] = g_checksum;
				TX2B = UploadBuf[0];	    //дͻ
				g_tp =1;
				TX2IE = 1;				//ʹTXж 
			}		
		}
		else
		{
			if(Tx_timer==0){Tx_timer =1;}
		}
    }	

	if(TX2IE && TX2IF)				//UARTж  
  	{	
		if(g_tp < g_length+5)
		{
			TX2B = UploadBuf[g_tp];	//дͻ
			g_tp ++; 
		}
		else
		{
			g_tp = 0;				//ָ0
			TX2IE = 0;				//ֹTXж 	
			Tx_timer=0;             //Clear counter
		}
    }
   #endif
}




